

<?php $__env->startSection('title', 'Verify'); ?>
<?php $__env->startSection('subtitle', 'Review upgrade details'); ?>

<?php $__env->startSection('content'); ?>
    <h2 style="margin-bottom: var(--spacing-lg); color: var(--white);">Upgrade Details</h2>
    
    <p style="margin-bottom: var(--spacing-lg);">
        Please review the upgrade information below before proceeding.
    </p>
    
    <div class="info-card">
        <h3><i class="fas fa-box"></i> Upgrade Information</h3>
        
        <div class="info-item">
            <div class="info-label">Current Version</div>
            <div class="info-value"><?php echo e($packageInfo['current_version']); ?></div>
        </div>
        
        <div class="info-item">
            <div class="info-label">New Version</div>
            <div class="info-value" style="color: var(--success); font-weight: 600;">
                <?php echo e($packageInfo['new_version']); ?>

            </div>
        </div>
        
        <div class="info-item">
            <div class="info-label">Release Date</div>
            <div class="info-value"><?php echo e($packageInfo['release_date']); ?></div>
        </div>
        
        <div class="info-item">
            <div class="info-label">Files to Update</div>
            <div class="info-value"><?php echo e($packageInfo['files_count']); ?> files</div>
        </div>
        
        <div class="info-item">
            <div class="info-label">Database Migration</div>
            <div class="info-value">
                <?php if($packageInfo['requires_database_migration']): ?>
                    <span style="color: var(--warning);">
                        <i class="fas fa-database"></i> Required
                    </span>
                <?php else: ?>
                    <span style="color: var(--success);">
                        <i class="fas fa-check"></i> Not required
                    </span>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <?php if(count($packageInfo['changes']) > 0): ?>
        <div style="margin-top: var(--spacing-lg);">
            <h3 style="color: var(--white); margin-bottom: var(--spacing-md);">
                <i class="fas fa-list"></i> What's New
            </h3>
            
            <div style="background-color: var(--dark-gray); border-radius: var(--border-radius-lg); padding: var(--spacing-lg); border: 1px solid var(--dark-gray-lightest);">
                <ul style="padding-left: var(--spacing-xl); margin: 0;">
                    <?php $__currentLoopData = $packageInfo['changes']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $change): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li style="margin-bottom: var(--spacing-sm); color: var(--lighter-gray);">
                            <?php echo e($change); ?>

                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        </div>
    <?php endif; ?>
    
    <div style="margin-top: var(--spacing-xl); background-color: rgba(75, 139, 255, 0.1); border-radius: var(--border-radius-md); padding: var(--spacing-lg); border: 1px solid rgba(75, 139, 255, 0.2);">
        <div style="display: flex; align-items: flex-start;">
            <i class="fas fa-shield-alt" style="color: var(--primary-color); margin-right: var(--spacing-sm); margin-top: 3px;"></i>
            <div>
                <p style="font-weight: 500; margin-bottom: var(--spacing-xs);">Safety First</p>
                <p style="font-size: 0.9rem; margin: 0;">
                    The next step will automatically create a complete backup of your application and database. This ensures you can rollback if anything goes wrong.
                </p>
            </div>
        </div>
    </div>
    
    <form action="<?php echo e(route('upgrade.backup')); ?>" method="POST" id="verifyForm">
        <?php echo csrf_field(); ?>
    </form>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer'); ?>
    <a href="<?php echo e(route('upgrade.index')); ?>" class="btn">
        <i class="fas fa-arrow-left"></i> Cancel
    </a>
    <button type="submit" form="verifyForm" class="btn btn-primary">
        <i class="fas fa-arrow-right"></i> Continue
    </button>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('upgrade.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/siedestudios.co.uk/edge/resources/views/upgrade/verify.blade.php ENDPATH**/ ?>